/***************************************************************************\
 *
 *               (C) copyright Fraunhofer - IIS (2012)
 *                        All Rights Reserved
 *
 *   Project:  CoreAudio AAC-ELD Example Source Code
 *
 *   By using this Example Source Code, you agree to the "Terms & Conditions 
 *   for Use of Fraunhofer Example Source Code", which is provided as a 
 *   separate document together with this file. The "Terms & Conditions for 
 *   Use of Fraunhofer Example Source Code" must be part of any redistribution
 *   of the Example Source Code or parts thereof, or modifications of the 
 *   Example Source Code.
 *
 \***************************************************************************/

#import "SimpleViewController.h"
#import "AudioUnitIO.h"
#import "AACELDEncoder.h"
#import "AACELDDecoder.h"

@implementation SimpleViewController
@synthesize startButton;

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
      audioIsRunning = NO;
    }
    return self;
}

- (void)dealloc
{
  [startButton release];
  [super dealloc];
}

- (void)didReceiveMemoryWarning
{
  // Releases the view if it doesn't have a superview.
  [super didReceiveMemoryWarning];
  // Release any cached data, images, etc that aren't in use.
}

#pragma mark - View lifecycle

- (void)viewDidLoad
{
  [super viewDidLoad];
}

- (void)viewDidUnload
{
  [self setStartButton:nil];
  [super viewDidUnload];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
  // Return YES for supported orientations
  return (interfaceOrientation == UIInterfaceOrientationPortrait);
}

- (IBAction)startButtonPressed:(id)sender {  
  if (!audioIsRunning)
  {
    InitAudioUnit();
    StartAudioUnit();
    [startButton setTitle:@"Stop" forState:UIControlStateNormal];
    audioIsRunning = YES;
  }
  else
  {
    StopAudioUnit();
    [startButton setTitle:@"Start" forState:UIControlStateNormal];
    audioIsRunning = NO;
  }  
}

@end
